currentlyPlaying = nil

---@param a BassAudio
function stream_play(a)
	if currentlyPlaying then audio_stream_stop(currentlyPlaying) end
	audio_stream_play(a, true, 1)
	currentlyPlaying = a
end

function stream_stop_all()
	currentlyPlaying = nil
end

gSamples = {
	audio_sample_load("s-shroom.mp3"),
}

sShroomDie = 1

function local_play(id, pos, vol)
	audio_sample_play(gSamples[id], pos, (is_game_paused() and 0 or vol))
end

-- global audio functions, credits to birdekek and Cooliokid 956

function network_play(id, pos, vol, i)
    local_play(id, pos, vol)
    network_send(true, {id = id, x = pos.x, y = pos.y, z = pos.z, vol = vol, i = network_global_index_from_local(i)})
end

function sm64_audio_network_play(sound, pos)
    play_sound(sound, pos)
    network_send(false, {sound = sound, x = pos.x, y = pos.y, z = pos.z})
end

local function packet_receive(data)
    if data.sound then
        play_sound(data.sound, {x=data.x, y=data.y, z=data.z})
    end
end

hook_event(HOOK_ON_PACKET_RECEIVE, packet_receive)